﻿using System;
using System.Collections.Generic;
using System.Drawing;
using System.Linq;
using System.Text;

namespace Inet.Viewer.Data
{
    /// <summary>
    /// Represents a subsequence of characters in a text block.
    /// </summary>
    public class TextBlockRange
    {
        private TextBlock block;
        private RectangleF bbox;
        private int startIndex;
        private int endIndex;

        /// <summary>
        /// Creates an instance.
        /// </summary>
        /// <param name="block">the text block</param>
        /// <param name="startIndex">the first character of the subsequence</param>
        /// <param name="endIndex">the last character of the subsequence</param>
        public TextBlockRange(TextBlock block, int startIndex, int endIndex)
        {
            this.block = block;
            this.startIndex = startIndex;
            this.endIndex = endIndex;
            this.SubString = block.Text.Substring(startIndex, endIndex - startIndex);

            // compute the bounding box from the individual character bounding boxes
            bbox = block.CharacterBounds[startIndex];
            for (int i = 1 + startIndex; i < endIndex; i++)
            {
                bbox = RectangleF.Union(bbox, block.CharacterBounds[i]);
            }
        }

        /// <summary>
        /// The bounding box of the character subsequence.
        /// </summary>
        public System.Drawing.RectangleF BBox { get { return bbox; } }

        /// <summary>
        /// The string of the character subsequeunce. 
        /// </summary>
        public string SubString { get; set; }
    }
}
